/** @file   DataWarehouse.cpp
 * @brief   Implementation of DataWarehouse class.
 * @version $Revision: 1.3 $
 * @date    $Date: 2006/02/21 20:48:27 $
 * @author  Tomi Lamminsaari
 */

#include "DataWarehouse.h"
#include "BaseContainer.h"
#include "datatypes.h"


namespace eng2d {

///
/// Constants, datatypes and static methods
/// ============================================================================




///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
DataWarehouse::DataWarehouse()
{
}



/** Destructor.
 */
DataWarehouse::~DataWarehouse()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================




///
/// New public methods
/// ============================================================================

/** Adds new item to this warehouse.
 */
int DataWarehouse::AddItem( int aUid, BaseContainer* aItem )
{
  if ( this->Find( aUid ) != 0 ) {
    delete aItem;
    return KErrAlreadyExists;
  }
  
  iItems[ aUid ] = aItem;
  return KErrNone;
}



/** Deletes the contents.
 */
void DataWarehouse::Reset()
{
  std::map<int, BaseContainer*>::const_iterator it = iItems.begin();
  for ( it=iItems.begin(); it != iItems.end(); it++ ) {
    delete it->second;
  }
  iItems.clear();
}



///
/// Getter methods
/// ============================================================================

/** Searches for item with given uid.
 */
BaseContainer* DataWarehouse::Find( int aUid ) const
{
  std::map<int, BaseContainer*>::const_iterator it = iItems.find(aUid);
  if ( it == iItems.end() ) {
    return 0;
  }
  return it->second;
}



/** Returns the Begin iterator.
 */
DataWarehouse::Iterator DataWarehouse::Begin() const
{
  return iItems.begin();
}



/** Returns the end iterator.
 */
DataWarehouse::Iterator DataWarehouse::End() const
{
  return iItems.end();
}


///
/// Protected and private methods
/// ============================================================================


}
